<?php
/**
* @package      Komento
* @copyright    Copyright (C) 2010 - 2018 Stack Ideas Sdn Bhd. All rights reserved.
* @license      GNU/GPL, see LICENSE.php
* Komento is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined('_JEXEC') or die('Restricted access');

KT::import('admin:/views/views');

class KomentoViewMigrators extends KomentoAdminView
{
	public function migrateComments()
	{
		$component = $this->input->get('component', '', 'string');
		$getPosts = $this->input->get('getPosts', false, 'boolean');

		if (!$component) {
			die('Invalid migration');
		}

		switch($component)
		{
			case 'com_easyblog':

				$publishState = $this->input->get('publishState', '');
				$categoryId = $this->input->get('categoryId');
				$migrateLikes = $this->input->get('migrateLikes', '');

				$migrator = KT::migrator()->getAdapter('easyblog');

				$migrator->migrate($categoryId, $publishState, $migrateLikes);
				break;
			case 'com_k2':

				$publishState = $this->input->get('publishState', '');
				$categoryId = $this->input->get('categoryId');

				$migrator = KT::migrator()->getAdapter('k2');

				$migrator->migrate($categoryId, $publishState);
				break;

			case 'com_zoo':

				$publishState = $this->input->get('publishState', '');
				$categoryId = $this->input->get('categoryId');
				$itemId = $this->input->get('itemId', '');

				$migrator = KT::migrator()->getAdapter('zoo');

				if ($getPosts) {
					$migrator->getPosts($categoryId);
				} else {
					$migrator->migrate($itemId, $publishState);
				}
				break;

			case 'custom':

				$data = $this->input->get('data', array(), 'array');
				$task = $this->input->get('task', 'migrate');

				$migrator = KT::migrator()->getAdapter('custom');
				$migrator->$task($data);
				break;

			case 'jacomment':

				$publishState = $this->input->get('publishState', '');
				$selectedComponent = $this->input->get('selectedComponent');

				$migrator = KT::migrator()->getAdapter('jacomment');
				$migrator->migrate($publishState, $selectedComponent);

				break;
			case 'jcomments':

				$publishState = $this->input->get('publishState', '');
				$selectedComponent = $this->input->get('selectedComponent');
				$migrateLikes = $this->input->get('migrateLikes', '');

				$migrator = KT::migrator()->getAdapter('jcomments');

				$migrator->migrate($publishState, $migrateLikes, $selectedComponent);
				break;

			case 'rscomments':

				$publishState = $this->input->get('publishState', '');
				$selectedComponent = $this->input->get('selectedComponent');
				$itemId = $this->input->get('itemId', '');

				$migrator = KT::migrator()->getAdapter('rscomments');

				if ($getPosts) {
					$migrator->getPosts($selectedComponent);
				} else {
					$migrator->migrate($itemId, $publishState, $selectedComponent);
				}
				break;

			case 'slicomments':

				$publishState = $this->input->get('publishState', '');
				$categoryId = $this->input->get('categoryId');
				$itemId = $this->input->get('itemId', '');

				$migrator = KT::migrator()->getAdapter('slicomments');

				if ($getPosts) {
					$migrator->getPosts($categoryId);
				} else {
					$migrator->migrate($itemId, $publishState);
				}
				break;

			default:
				break;
		}
	}

	public function getColumns()
	{
		$tableName = $this->input->get('tableName');

		$columns = KT::db()->getColumns($tableName);

		$html = '';

		foreach ($columns as $column) {
			$html .= '<option value="' . $column . '">' . $column . '</option>';
		}

		return $this->ajax->resolve($html);
	}
}

