!function ($) {
    "use strict";

    var Tab = function(element){
        this.element = $(element);
    }

    Tab.prototype = {
        constructor: Tab,
        show: function(){
            var $this = this.element,
                $ul = $this.closest('ul:not(.dropdown-menu)'),
                selector = $this.attr('data-target'),
                previous, $target, e;
            if (!selector) {
                selector = $this.attr('href');
            }
            if ($this.parent('li').hasClass('active')) return;
            previous = $ul.find('.active:last a')[0];
            e = $.Event('show', {
                relatedTarget: previous
            });
            $this.trigger(e);
            if (e.isDefaultPrevented()) return;
            $target = $(selector);
            this.activate($this.parent('li'), $ul);
            this.activate($target, $target.parent(), function(){
                $this.trigger({
                    type: 'shown',
                    relatedTarget: previous
                });
            });
        },
        activate: function(element, container, callback){
            var $active = container.find('> .active'),
                transition = callback && $.support.transition && $active.hasClass('fade');
            function next() {
                $active.removeClass('active').find('> .dropdown-menu > .active').removeClass('active');
                element.addClass('active')
                if (transition) {
                    element[0].offsetWidth;
                    element.addClass('in');
                } else {
                    element.removeClass('fade');
                }
                if (element.parent('.dropdown-menu')) {
                    element.closest('li.dropdown').addClass('active');
                }
                callback && callback();
            }
            transition ? $active.one($.support.transition.end, next) : next();
            $active.removeClass('in');
        }
    }

    var old = $.fn.tab;
    $.fn.tab = function(option){
        return this.each(function(){
            var $this = $(this),
                data = $this.data('tab');
                if (!data) $this.data('tab', (data = new Tab(this)));
                if (typeof option == 'string') data[option]();
            });
    }
    $.fn.tab.Constructor = Tab;
    $.fn.tab.noConflict = function(){
        $.fn.tab = old;
        return this;
    }

    $(document).on('click.tab.data-api', '[data-toggle="tab"], [data-toggle="pill"]', function(e){
        e.preventDefault();
        $(this).tab('show');
    });
}(window.jQuery);

!function ($) {
    "use strict";

    var Modal = function(element, options){
        this.options = options;
        this.$element = $(element).delegate('[data-dismiss="modal"]', 'click.dismiss.modal', $.proxy(this.hide, this));
        this.options.remote && this.$element.find('.modal-body').load(this.options.remote);
    }

    Modal.prototype = {
        constructor: Modal,
        toggle: function(){
            return this[!this.isShown ? 'show' : 'hide']();
        },
        show: function(){
            var that = this,
                e = $.Event('show');
            this.$element.trigger(e);
            if (this.isShown || e.isDefaultPrevented()) return;
            this.isShown = true;
            this.escape();
            this.backdrop(function(){
                var transition = $.support.transition && that.$element.hasClass('fade');
                if (!that.$element.parent().length) {
                    that.$element.appendTo(document.body);
                }
                that.$element.show();
                if (transition) {
                    that.$element[0].offsetWidth;
                }
                that.$element.addClass('in').attr('aria-hidden', false);
                that.enforceFocus();
                transition ?
                    that.$element.one($.support.transition.end, function(){that.$element.focus().trigger('shown')}) :
                    that.$element.focus().trigger('shown');
                });
        },
        hide: function(e){
            e && e.preventDefault();
            var that = this;
            e = $.Event('hide');
            this.$element.trigger(e);
            if (!this.isShown || e.isDefaultPrevented()) return;
            this.isShown = false;
            this.escape();
            $(document).off('focusin.modal');
            this.$element.removeClass('in').attr('aria-hidden', true);
            $.support.transition && this.$element.hasClass('fade') ? this.hideWithTransition() : this.hideModal();
        },
        enforceFocus: function(){
            var that = this;
            $(document).on('focusin.modal', function(e){
                if (that.$element[0] !== e.target && !that.$element.has(e.target).length) {
                    that.$element.focus();
                }
            });
        },
        escape: function(){
            var that = this;
            if (this.isShown && this.options.keyboard) {
                this.$element.on('keyup.dismiss.modal', function(e){
                    e.which == 27 && that.hide();
                });
            } else if (!this.isShown) {
                this.$element.off('keyup.dismiss.modal');
            }
        },
        hideWithTransition: function(){
            var that = this,
                timeout = setTimeout(function(){
                    that.$element.off($.support.transition.end);
                    that.hideModal();
                }, 500);
            this.$element.one($.support.transition.end, function(){
                clearTimeout(timeout);
                that.hideModal();
            });
        },
        hideModal: function(){
            var that = this;
            this.$element.hide();
            this.backdrop(function(){
                that.removeBackdrop();
                that.$element.trigger('hidden');
            });
        },
        removeBackdrop: function(){
            this.$backdrop && this.$backdrop.remove();
            this.$backdrop = null;
        },
        backdrop: function(callback){
            var that = this,
                animate = this.$element.hasClass('fade') ? 'fade' : '';
            if (this.isShown && this.options.backdrop) {
                var doAnimate = $.support.transition && animate;
                this.$backdrop = $('<div class="modal-backdrop ' + animate + '" />').appendTo(document.body);
                this.$backdrop.click(this.options.backdrop == 'static' ?
                    $.proxy(this.$element[0].focus, this.$element[0]) : $.proxy(this.hide, this));
                if (doAnimate) this.$backdrop[0].offsetWidth;
                this.$backdrop.addClass('in');
                if (!callback) return;
                doAnimate ? this.$backdrop.one($.support.transition.end, callback) : callback();
            } else if (!this.isShown && this.$backdrop) {
                this.$backdrop.removeClass('in');
                $.support.transition && this.$element.hasClass('fade') ?
                this.$backdrop.one($.support.transition.end, callback) : callback();
            } else if (callback) {
                callback();
            }
        }
    }

    var old = $.fn.modal;
    $.fn.modal = function(option){
        return this.each(function(){
            var $this = $(this),
                data = $this.data('modal'),
                options = $.extend({}, $.fn.modal.defaults, $this.data(), typeof option == 'object' && option);
            if (!data) {
                $this.data('modal', (data = new Modal(this, options)))
            }
            if (typeof option == 'string') {
                data[option]();
            } else if (options.show) {
                data.show();
            }
        });
    }
    $.fn.modal.defaults = {
        backdrop: true,
        keyboard: true,
        show: true
    }
    $.fn.modal.Constructor = Modal;
    $.fn.modal.noConflict = function(){
        $.fn.modal = old;
        return this;
    }
    $(document).on('click.modal.data-api', '[data-toggle="modal"]', function(e){
        var $this = $(this),
            href = $this.attr('href'),
            $target = $($this.attr('data-target') || (href && href.replace(/.*(?=#[^\s]+$)/, ''))), //strip for ie7
            option = $target.data('modal') ? 'toggle' : $.extend({ remote:!/#/.test(href) && href }, $target.data(), $this.data());
        e.preventDefault();
        $target.modal(option).one('hide', function(){
            $this.focus();
        });
    });
}(window.jQuery);