<?php
/*-------------------------------------------------------------------------
# com_creative_slider - Creative Slider
# -------------------------------------------------------------------------
# @ author    John Gera, George Krupa, Janos Biro, Balint Polgarfi
# @ copyright Copyright (C) 2018 Offlajn.com  All Rights Reserved.
# @ license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# @ website   http://www.offlajn.com
-------------------------------------------------------------------------*/
namespace CreativeSlider;
use stdClass, ZipArchive;
defined('_JEXEC') or die;
?><?php

$l10n_ls = array(

	// General
	'save' 		=> __('Save changes', 'LayerSlider'),
	'saving' 	=> __('Saving ...', 'LayerSlider'),
	'saved' 	=> __('Saved', 'LayerSlider'),
	'error' 	=> __('ERROR', 'LayerSlider'),
	'untitled' 	=> __('Untitled', 'LayerSlider'),
	'working' 	=> __('Working ...', 'LayerSlider'),
	'stop' 		=> __('Stop', 'LayerSlider'),

	'slideNoun' 	=> _x('Slide', 'noun', 'LayerSlider'),
	'slideVerb' 	=> _x('Slide', 'verb', 'LayerSlider'),
	'layer' 		=> __('Layer', 'Layer'),

	'selectAll' 	=> __('Select all', 'LayerSlider'),
	'deselectAll' 	=> __('Deselect all', 'LayerSlider'),

	// Notify OSD
	'notifySliderSaved' => __('Slider saved successfully'),
	'notifyCaptureSlide' => __('Capturing page. This might take a moment ...'),

	// Sliders list
	'SLRemoveSlider' 	=> __('Are you sure you want to remove this slider?', 'LayerSlider'),
	'SLUploadSlider' 	=> __('Uploading, please wait ...', 'LayerSlider'),
	'SLEnterCode' 		=> __('Please enter a valid Item Purchase Code. For more information, please click on the “Where’s my purchase code?” button.', 'LayerSlider'),
	'SLDeactivate' 		=> __('Are you sure you want to deactivate this site?', 'LayerSlider'),
	'SLPermissions' 	=> __('WARNING: This option controls who can access to this plugin, you can easily lock out yourself by accident. Please, make sure that you have entered a valid capability without whitespaces or other invalid characters. Do you want to proceed?', 'LayerSlider'),
	'SLJQueryConfirm' 	=> __('Do not enable this option unless you’re  experiencing issues with jQuery on your site. This option can easily cause unexpected issues when used incorrectly. Do you want to proceed?', 'LayerSlider'),
	'SLJQueryReminder' 	=> __('Do not forget to disable this option later on if it does not help, or if you experience unexpected issues. This includes your entire site, not just LayerSlider.', 'LayerSlider'),

	'SLImporting' 		=> __('Importing, please wait...', 'LayerSlider'),
	'SLImportError' 	=> __('It seems there is a server issue that prevented LayerSlider from importing your selected slider. Please check LayerSlider -> System Status for potential errors, try to temporarily disable themes/plugins to rule out incompatibility issues or contact your hosting provider to resolve server configuration problems. In many cases retrying to import the same slider can help.', 'LayerSlider'),
	'SLImportHTTPError' => __('It seems there is a server issue that prevented LayerSlider from importing your selected slider. Please check LayerSlider -> System Status for potential errors, try to temporarily disable themes/plugins to rule out incompatibility issues or contact your hosting provider to resolve server configuration problems. In many cases retrying to import the same slider can help. Your HTTP server thrown the following error: \n\n %s', 'LayerSlider'),

	// Template Store
	'TSImportWarningTitle' 		=> __('Activate your site to access premium templates.', 'LayerSlider'),
	'TSImportWarningContent' 	=> sprintf(__('This template is only available for activated sites. Please review the PRODUCT ACTIVATION section on the main LayerSlider screen or %sclick here%s for more information.', 'LayerSlider'), '<a href=\"http://docs.offlajn.com/creative-slider#activation\" target=\"_blank\">', '</a>'),
	'TSVersionWarningTitle' 	=> __('Plugin update required', 'LayerSlider'),
	'TSVersionWarningContent' 	=> sprintf(__('This slider template requires a newer version of LayerSlider in order to work properly. This is due to additional features introduced in a later version than you have. For updating instructions, please refer to our %sonline documentation%s.', 'LayerSlider'), '<a href="http://docs.offlajn.com/creative-slider#updating" target="_blank">', '</a>'),

	// Google Fonts
	'GFEmptyList' 		=> __('You haven’t added any Google Font to your collection yet.', 'LayerSlider'),
	'GFEmptyCharset' 	=> __('You need to have at least one character set added. Please select another item before removing this one.', 'LayerSlider'),
	'GFFontFamily' 		=> __('Choose a font family', 'LayerSlider'),
	'GFFontVariant' 	=> __('Select %s font variants', 'LayerSlider'),

	// Slider Builder
	'SBSlideTitle' 				=> __('Slide #%d', 'LayerSlider'),
	'SBSlideCopyTitle' 			=> __('Slide #%d copy', 'LayerSlider'),
	'SBLayerTitle' 				=> __('Layer #%d', 'LayerSlider'),
	'SBLayerCopyTitle' 			=> __('Layer #%d copy', 'LayerSlider'),
	'SBUndoLayer' 				=> __('Layer settings', 'LayerSlider'),
	'SBUndoSlide' 				=> __('Slide settings', 'LayerSlider'),
	'SBUndoNewLayer' 			=> __('New layer', 'LayerSlider'),
	'SBUndoNewLayers' 			=> __('New layers', 'LayerSlider'),
	'SBUndoVideoPoster' 		=> __('Video poster', 'LayerSlider'),
	'SBUndoRemoveVideoPoster'	=> __('Remove video poster', 'LayerSlider'),
	'SBUndoLayerPosition' 		=> __('Layer position', 'LayerSlider'),
	'SBUndoRemoveLayer' 		=> __('Remove layer(s)', 'LayerSlider'),
	'SBUndoHideLayer' 			=> __('Hide layer', 'LayerSlider'),
	'SBUndoLockLayer' 			=> __('Lock layer', 'LayerSlider'),
	'SBUndoPasteSettings' 		=> __('Paste layer settings', 'LayerSlider'),
	'SBUndoSlideImage' 			=> __('Slide image', 'LayerSlider'),
	'SBUndoLayerImage' 			=> __('Layer image', 'LayerSlider'),
	'SBUndoSortLayers' 			=> __('Sort layers', 'LayerSlider'),
	'SBUndoLayerType' 			=> __('Layer type', 'LayerSlider'),
	'SBUndoLayerMedia' 			=> __('Layer media', 'LayerSlider'),
	'SBUndoLayerResize' 		=> __('Layer resize', 'LayerSlider'),
	'SBUndoAlignLayer' 			=> __('Align layer(s)', 'LayerSlider'),
	'SBUndoRemoveSlideImage' 	=> __('Remove slide image', 'LayerSlider'),
	'SBUndoRemoveLayerImage' 	=> __('Remove layer image', 'LayerSlider'),
	'SBDragMe' 					=> __('Drag me :)', 'LayerSlider'),
	'SBPreviewSlide' 			=> __('Preview Slide', 'LayerSlider'),
	'SBLayerPreviewMultiSelect' => __('Layer Preview is not available in Multiple Selection Mode. Select only one layer to use this feature. ', 'LayerSlider'),
	'SBStaticUntil' 			=> __('Until the end of Slide #%d', 'LayerSlider'),
	'SBPasteLayerError'			=> __('There’s nothing to paste. Copy a layer first!', 'LayerSlider'),
	'SBPasteError' 				=> __('There is nothing to paste!', 'LayerSlider'),
	'SBRemoveSlide' 			=> __('Are you sure you want to remove this slide?', 'LayerSlider'),
	'SBRemoveLayer' 			=> __('Are you sure you want to remove this layer?', 'LayerSlider'),
	'SBMediaLibraryImage' 		=> __('Pick an image to use it in LayerSlider WP', 'LayerSlider'),
	'SBUploadError' 			=> __('Upload error', 'LayerSlider'),
	'SBUploadErrorMessage' 		=> __('Upload error: %s', 'LayerSlider'),
	'SBInvalidFormat' 			=> __('Invalid format', 'LayerSlider'),
	'SBEnterImageURL' 			=> __('Enter an image URL', 'LayerSlider'),
	'SBTransitionApplyOthers' 	=> __('Are you sure you want to apply the currently selected transitions and effects on the other slides?', 'LayerSlider'),
	'SBPostFilterWarning' 		=> __('No posts were found with the current filters.', 'LayerSlider'),
	'SBSaveError' 				=> __('It seems there is a server issue that prevented LayerSlider from saving your work. Please check LayerSlider -> System Status for potential errors, try to temporarily disable themes/plugins to rule out incompatibility issues or contact your hosting provider to resolve server configuration problems. Your HTTP server thrown the following error: \n\n %s', 'LayerSlider'),
	'SBUnsavedChanges' 			=> __('You have unsaved changes on this page. Do you want to leave and discard the changes made since your last save?', 'LayerSlider'),
	'SBLinkTextPage' 			=> __('Linked to WP Page: %s', 'LayerSlider'),
	'SBLinkTextPost' 			=> __('Linked to WP Post: %s', 'LayerSlider'),
	'SBLinkTextAttachment' 		=> __('Linked to WP Attachment: %s', 'LayerSlider'),
	'SBLinkPostDynURL' 			=> __('Linked to: Post URL from Dynamic content', 'LayerSlider'),


	// Transition Builder
	'TBTransitionName' 		=> __('Type transition name', 'LayerSlider'),
	'TBRemoveTransition' 	=> __('Remove transition', 'LayerSlider'),
	'TBRemoveConfirmation' 	=> __('Are you sure you want to remove this transition?', 'LayerSlider'),
);